/* 
 *  EndRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;

public class EndRequest extends InteractionRequest {

	private String closeReasonCode=null;
	private String closingAgentNote=null;
	private boolean sendTranscript;
	
	private static final Logger LOG = Logger.getLogger(EndRequest.class);
    
    //used by voice interaction
    public EndRequest(String interactionID) {
        super(LOG, interactionID);
    }

    //used by multimedia interaction
    public EndRequest(String interactionID, String closeReasonCode, String closingAgentNote, boolean sendTranscript) {
		super(LOG, interactionID);
		this.closeReasonCode=closeReasonCode;
		this.closingAgentNote=closingAgentNote;
		this.sendTranscript=sendTranscript;
	}

	/**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        if (closeReasonCode==null&&closingAgentNote==null) {
        	//voice interaction
        	getInteraction().end();
        } else {
        	//multimedia interaction
        	getInteraction().end(closeReasonCode, closingAgentNote, sendTranscript);
        }
        
        LOG.trace(methodName + "-");
        return null;
    }
}
